/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.modifiers;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.MultiMap;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.modifiers.ModifierPredicate;
import org.jetbrains.annotations.NotNull;

abstract class ModifierIntention
extends Intention
implements LowPriorityAction {
    ModifierIntention() {
    }

    @Override
    @NotNull
    protected final PsiElementPredicate getElementPredicate() {
        return new ModifierPredicate(this.getModifier());
    }

    @Override
    protected final void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        boolean conflictsDialogOK;
        PsiMember member = (PsiMember)element.getParent();
        final PsiModifierList modifierList = member.getModifierList();
        if (modifierList == null) {
            return;
        }
        MultiMap<PsiElement, String> conflicts = this.checkForConflicts(member);
        Project project2 = member.getProject();
        if (conflicts.isEmpty()) {
            conflictsDialogOK = true;
        } else {
            ConflictsDialog conflictsDialog = new ConflictsDialog(project2, conflicts, new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            modifierList.setModifierProperty(ModifierIntention.this.getModifier(), true);
                        }
                    });
                }
            });
            conflictsDialogOK = conflictsDialog.showAndGet();
        }
        if (conflictsDialogOK) {
            modifierList.setModifierProperty(this.getModifier(), true);
            PsiElement whitespace = PsiParserFacade.SERVICE.getInstance((Project)project2).createWhiteSpaceFromText(" ");
            PsiElement sibling = modifierList.getNextSibling();
            if (sibling instanceof PsiWhiteSpace) {
                sibling.replace(whitespace);
                CodeStyleManager.getInstance((Project)project2).reformatRange((PsiElement)member, modifierList.getTextOffset(), modifierList.getNextSibling().getTextOffset());
            }
        }
    }

    private MultiMap<PsiElement, String> checkForConflicts(final @NotNull PsiMember member) {
        if (member instanceof PsiClass && this.getModifier().equals("public")) {
            String className;
            PsiClass aClass = (PsiClass)member;
            PsiElement parent = aClass.getParent();
            if (!(parent instanceof PsiJavaFile)) {
                return MultiMap.emptyInstance();
            }
            PsiJavaFile javaFile = (PsiJavaFile)parent;
            String name = FileUtil.getNameWithoutExtension((String)javaFile.getName());
            if (name.equals(className = aClass.getName())) {
                return MultiMap.emptyInstance();
            }
            MultiMap conflicts = new MultiMap();
            conflicts.putValue((Object)aClass, (Object)IntentionPowerPackBundle.message("0.is.declared.in.1.but.when.public.should.be.declared.in.a.file.named.2", RefactoringUIUtil.getDescription((PsiElement)aClass, false), RefactoringUIUtil.getDescription((PsiElement)javaFile, false), CommonRefactoringUtil.htmlEmphasize((String)(className + ".java"))));
            return conflicts;
        }
        PsiModifierList modifierList = member.getModifierList();
        if (modifierList == null || modifierList.hasModifierProperty("private")) {
            return MultiMap.emptyInstance();
        }
        final MultiMap conflicts = new MultiMap();
        if (member instanceof PsiMethod) {
            final PsiMethod method = (PsiMethod)member;
            SuperMethodsSearch.search((PsiMethod)method, (PsiClass)method.getContainingClass(), (boolean)true, (boolean)false).forEach((Processor)new Processor<MethodSignatureBackedByPsiMethod>(){

                public boolean process(MethodSignatureBackedByPsiMethod methodSignature) {
                    PsiMethod superMethod = methodSignature.getMethod();
                    if (!ModifierIntention.this.hasCompatibleVisibility(superMethod, true)) {
                        conflicts.putValue((Object)superMethod, (Object)IntentionPowerPackBundle.message("0.will.have.incompatible.access.privileges.with.super.1", RefactoringUIUtil.getDescription((PsiElement)method, false), RefactoringUIUtil.getDescription((PsiElement)superMethod, true)));
                    }
                    return true;
                }
            });
            OverridingMethodsSearch.search((PsiMethod)method).forEach((Processor)new Processor<PsiMethod>(){

                public boolean process(PsiMethod overridingMethod) {
                    if (!ModifierIntention.this.isVisibleFromOverridingMethod(method, overridingMethod)) {
                        conflicts.putValue((Object)overridingMethod, (Object)IntentionPowerPackBundle.message("0.will.no.longer.be.visible.from.overriding.1", RefactoringUIUtil.getDescription((PsiElement)method, false), RefactoringUIUtil.getDescription((PsiElement)overridingMethod, true)));
                    } else if (!ModifierIntention.this.hasCompatibleVisibility(overridingMethod, false)) {
                        conflicts.putValue((Object)overridingMethod, (Object)IntentionPowerPackBundle.message("0.will.have.incompatible.access.privileges.with.overriding.1", RefactoringUIUtil.getDescription((PsiElement)method, false), RefactoringUIUtil.getDescription((PsiElement)overridingMethod, true)));
                    }
                    return false;
                }
            });
        }
        final PsiModifierList modifierListCopy = (PsiModifierList)modifierList.copy();
        modifierListCopy.setModifierProperty(this.getModifier(), true);
        Query search = ReferencesSearch.search((PsiElement)member, (SearchScope)member.getResolveScope());
        search.forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference reference) {
                PsiElement element = reference.getElement();
                if (JavaResolveUtil.isAccessible(member, member.getContainingClass(), modifierListCopy, element, null, null)) {
                    return true;
                }
                PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiField.class, PsiClass.class, PsiFile.class});
                if (context == null) {
                    return true;
                }
                conflicts.putValue((Object)element, (Object)RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, false), PsiBundle.visibilityPresentation((String)ModifierIntention.this.getModifier()), RefactoringUIUtil.getDescription(context, true)}));
                return true;
            }
        });
        return conflicts;
    }

    private boolean hasCompatibleVisibility(PsiMethod method, boolean isSuper) {
        if (this.getModifier().equals("private")) {
            return false;
        }
        if (this.getModifier().equals("packageLocal")) {
            if (isSuper) {
                return !method.hasModifierProperty("public") && !method.hasModifierProperty("protected");
            }
            return true;
        }
        if (this.getModifier().equals("protected")) {
            if (isSuper) {
                return !method.hasModifierProperty("public");
            }
            return method.hasModifierProperty("protected") || method.hasModifierProperty("public");
        }
        if (this.getModifier().equals("public")) {
            if (!isSuper) {
                return method.hasModifierProperty("public");
            }
            return true;
        }
        throw new AssertionError();
    }

    private boolean isVisibleFromOverridingMethod(PsiMethod method, PsiMethod overridingMethod) {
        PsiModifierList modifierListCopy = (PsiModifierList)method.getModifierList().copy();
        modifierListCopy.setModifierProperty(this.getModifier(), true);
        return JavaResolveUtil.isAccessible((PsiMember)method, method.getContainingClass(), modifierListCopy, (PsiElement)overridingMethod, null, null);
    }

    @VisibilityConstant
    protected abstract String getModifier();

    static @interface VisibilityConstant {
    }
}

