/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.junit;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.junit.AssertLiteralPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceAssertLiteralWithAssertEqualsIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        assert (methodName != null);
        String postfix = methodName.substring("assert".length());
        PsiExpression lastArgument = arguments[arguments.length - 1];
        if (lastArgument instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)lastArgument;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if ("assertTrue".equals(methodName) && JavaTokenType.EQEQ.equals(tokenType) || "assertFalse".equals(methodName) && JavaTokenType.NE.equals(tokenType)) {
                return IntentionPowerPackBundle.message("replace.assert.literal.with.assert.equals.intention.name2", methodName);
            }
        }
        String literal = postfix.toLowerCase();
        if (arguments.length == 1) {
            return IntentionPowerPackBundle.message("replace.assert.literal.with.assert.equals.intention.name", methodName, literal);
        }
        return IntentionPowerPackBundle.message("replace.assert.literal.with.assert.equals.intention.name1", methodName, literal);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new AssertLiteralPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiExpression lastArgument;
        PsiMethodCallExpression call = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (methodName == null) {
            return;
        }
        StringBuilder newExpression = new StringBuilder();
        PsiElement qualifier = methodExpression.getQualifier();
        if (qualifier == null) {
            PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            if (!InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"junit.framework.Assert") && !ImportUtils.addStaticImport("org.junit.Assert", "assertEquals", element)) {
                newExpression.append("org.junit.Assert.");
            }
        } else {
            newExpression.append(qualifier.getText());
            newExpression.append('.');
        }
        newExpression.append("assertEquals(");
        String postfix = methodName.substring("assert".length());
        String literal = postfix.toLowerCase();
        PsiExpressionList argumentList = call.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length > 1) {
            newExpression.append(arguments[0].getText()).append(", ");
        }
        if ((lastArgument = arguments[arguments.length - 1]) instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)lastArgument;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if ("assertTrue".equals(methodName) && JavaTokenType.EQEQ.equals(tokenType) || "assertFalse".equals(methodName) && JavaTokenType.NE.equals(tokenType)) {
                PsiExpression lhs = binaryExpression.getLOperand();
                newExpression.append(lhs.getText()).append(", ");
                PsiExpression rhs = binaryExpression.getROperand();
                if (rhs != null) {
                    newExpression.append(rhs.getText());
                }
            } else {
                newExpression.append(literal).append(", ").append(lastArgument.getText());
            }
        } else {
            newExpression.append(literal).append(", ").append(lastArgument.getText());
        }
        newExpression.append(')');
        PsiReplacementUtil.replaceExpression((PsiExpression)call, newExpression.toString());
    }
}

