/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.junit;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.junit.CreateAssertPredicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CreateAssertIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new CreateAssertPredicate();
    }

    @Override
    public void processIntention(PsiElement element) {
        String newStatement;
        PsiExpressionStatement statement2 = (PsiExpressionStatement)element;
        PsiExpression expression = statement2.getExpression();
        if (BoolUtils.isNegation(expression)) {
            newStatement = CreateAssertIntention.buildNewStatement("assertFalse", element, BoolUtils.getNegatedExpressionText(expression));
        } else if (CreateAssertIntention.isNullComparison(expression)) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            PsiExpression comparedExpression = ExpressionUtils.isNullLiteral(lhs) ? rhs : lhs;
            assert (comparedExpression != null);
            newStatement = JavaTokenType.EQEQ.equals(binaryExpression.getOperationTokenType()) ? CreateAssertIntention.buildNewStatement("assertNull", element, comparedExpression.getText()) : CreateAssertIntention.buildNewStatement("assertNotNull", element, comparedExpression.getText());
        } else if (CreateAssertIntention.isEqualityComparison(expression)) {
            PsiExpression comparingExpression;
            PsiExpression comparedExpression;
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs instanceof PsiLiteralExpression) {
                comparedExpression = rhs;
                comparingExpression = lhs;
            } else {
                comparedExpression = lhs;
                comparingExpression = rhs;
            }
            assert (comparingExpression != null);
            PsiType type = lhs.getType();
            newStatement = PsiType.DOUBLE.equals((Object)type) || PsiType.FLOAT.equals((Object)type) ? CreateAssertIntention.buildNewStatement("assertEquals", element, comparedExpression.getText(), comparingExpression.getText(), "0.0") : (type instanceof PsiPrimitiveType ? CreateAssertIntention.buildNewStatement("assertEquals", element, comparedExpression.getText(), comparingExpression.getText()) : CreateAssertIntention.buildNewStatement("assertSame", element, comparedExpression.getText(), comparingExpression.getText()));
        } else if (CreateAssertIntention.isEqualsExpression(expression)) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiExpression comparedExpression = methodExpression.getQualifierExpression();
            assert (comparedExpression != null);
            PsiExpressionList argList = call.getArgumentList();
            PsiExpression comparingExpression = argList.getExpressions()[0];
            newStatement = comparingExpression instanceof PsiLiteralExpression ? CreateAssertIntention.buildNewStatement("assertEquals", element, comparingExpression.getText(), comparedExpression.getText()) : CreateAssertIntention.buildNewStatement("assertEquals", element, comparedExpression.getText(), comparingExpression.getText());
        } else {
            newStatement = CreateAssertIntention.buildNewStatement("assertTrue", element, expression.getText());
        }
        PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)statement2, newStatement);
    }

    @NonNls
    private static String buildNewStatement(@NonNls String memberName, PsiElement context, String ... argumentTexts) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.getProject());
        StringBuilder builder = new StringBuilder(memberName).append('(');
        boolean comma = false;
        for (String argumentText : argumentTexts) {
            if (comma) {
                builder.append(',');
            } else {
                comma = true;
            }
            builder.append(argumentText);
        }
        builder.append(')');
        String text = builder.toString();
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)factory.createExpressionFromText(text, context);
        PsiMethod method = methodCallExpression.resolveMethod();
        if (CreateAssertIntention.isJUnitMethod(method) || CreateAssertIntention.hasStaticImports(context) && ImportUtils.addStaticImport("org.junit.Assert", memberName, context)) {
            return text + ';';
        }
        return "org.junit.Assert." + text + ';';
    }

    private static boolean isJUnitMethod(PsiMethod method) {
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String qualifiedName = containingClass.getQualifiedName();
        return "org.junit.Assert".equals(qualifiedName) || "junit.framework.TestCase".equals(qualifiedName);
    }

    private static boolean hasStaticImports(PsiElement element) {
        PsiFile file2 = element.getContainingFile();
        if (!(file2 instanceof PsiJavaFile)) {
            return false;
        }
        PsiJavaFile javaFile = (PsiJavaFile)file2;
        PsiImportList importList = javaFile.getImportList();
        return importList != null && importList.getImportStaticStatements().length > 0;
    }

    private static boolean isEqualsExpression(PsiExpression expression) {
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"equals".equals(methodName)) {
            return false;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null) {
            return false;
        }
        PsiExpressionList argList = call.getArgumentList();
        PsiExpression[] expressions = argList.getExpressions();
        return expressions.length == 1 && expressions[0] != null;
    }

    private static boolean isEqualityComparison(PsiExpression expression) {
        if (!(expression instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        return JavaTokenType.EQEQ.equals(tokenType);
    }

    private static boolean isNullComparison(PsiExpression expression) {
        if (!(expression instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (!JavaTokenType.EQEQ.equals(tokenType) && !JavaTokenType.NE.equals(tokenType)) {
            return false;
        }
        PsiExpression lhs = binaryExpression.getLOperand();
        if (ExpressionUtils.isNullLiteral(lhs)) {
            return true;
        }
        PsiExpression rhs = binaryExpression.getROperand();
        return ExpressionUtils.isNullLiteral(rhs);
    }
}

