/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.junit;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.junit.ConvertJUnit3TestCaseToJUnit4Predicate;
import org.jetbrains.annotations.NotNull;

public class ConvertJUnit3TestCaseToJUnit4Intention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new ConvertJUnit3TestCaseToJUnit4Predicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement[] referenceElements;
        PsiMethod[] methods;
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiClass)) {
            return;
        }
        PsiClass aClass = (PsiClass)parent;
        PsiReferenceList extendsList = aClass.getExtendsList();
        if (extendsList == null) {
            return;
        }
        for (PsiMethod method : methods = aClass.getMethods()) {
            PsiType returnType;
            String name = method.getName();
            if (method.hasModifierProperty("static") || !PsiType.VOID.equals((Object)(returnType = method.getReturnType()))) continue;
            PsiModifierList modifierList = method.getModifierList();
            if (name.startsWith("test")) {
                ConvertJUnit3TestCaseToJUnit4Intention.addAnnotationIfNotPresent(modifierList, "org.junit.Test");
            } else if (name.equals("setUp")) {
                ConvertJUnit3TestCaseToJUnit4Intention.transformSetUpOrTearDownMethod(method);
                ConvertJUnit3TestCaseToJUnit4Intention.addAnnotationIfNotPresent(modifierList, "org.junit.Before");
            } else if (name.equals("tearDown")) {
                ConvertJUnit3TestCaseToJUnit4Intention.transformSetUpOrTearDownMethod(method);
                ConvertJUnit3TestCaseToJUnit4Intention.addAnnotationIfNotPresent(modifierList, "org.junit.After");
            }
            method.accept((PsiElementVisitor)new MethodCallModifier());
        }
        for (PsiJavaCodeReferenceElement referenceElement : referenceElements = extendsList.getReferenceElements()) {
            referenceElement.delete();
        }
    }

    private static void addAnnotationIfNotPresent(PsiModifierList modifierList, String qualifiedAnnotationName) {
        if (modifierList.findAnnotation(qualifiedAnnotationName) != null) {
            return;
        }
        PsiAnnotation annotation = modifierList.addAnnotation(qualifiedAnnotationName);
        Project project2 = modifierList.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
        codeStyleManager.shortenClassReferences((PsiElement)annotation);
    }

    private static void transformSetUpOrTearDownMethod(PsiMethod method) {
        PsiAnnotation overrideAnnotation;
        PsiModifierList modifierList = method.getModifierList();
        if (modifierList.hasModifierProperty("protected")) {
            modifierList.setModifierProperty("protected", false);
        }
        if (!modifierList.hasModifierProperty("public")) {
            modifierList.setModifierProperty("public", true);
        }
        if ((overrideAnnotation = modifierList.findAnnotation("java.lang.Override")) != null) {
            overrideAnnotation.delete();
        }
        method.accept((PsiElementVisitor)new SuperLifeCycleCallRemover(method.getName()));
    }

    private static class MethodCallModifier
    extends JavaRecursiveElementVisitor {
        private MethodCallModifier() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            if (methodExpression.getQualifierExpression() != null) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String name = aClass.getQualifiedName();
            if (!"junit.framework.Assert".equals(name)) {
                return;
            }
            String newExpressionText = "org.junit.Assert." + expression.getText();
            Project project2 = expression.getProject();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            PsiExpression newExpression = factory.createExpressionFromText(newExpressionText, (PsiElement)expression);
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
            PsiElement replacedExpression = expression.replace((PsiElement)newExpression);
            codeStyleManager.shortenClassReferences(replacedExpression);
        }
    }

    private static class SuperLifeCycleCallRemover
    extends JavaRecursiveElementVisitor {
        @NotNull
        private final String myLifeCycleMethodName;

        private SuperLifeCycleCallRemover(@NotNull String lifeCycleMethodName) {
            this.myLifeCycleMethodName = lifeCycleMethodName;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!this.myLifeCycleMethodName.equals(methodName)) {
                return;
            }
            PsiExpression target = methodExpression.getQualifierExpression();
            if (!(target instanceof PsiSuperExpression)) {
                return;
            }
            expression.delete();
        }
    }
}

