/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.interfacetoclass;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.MultiMap;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.interfacetoclass.ConvertInterfaceToClassPredicate;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertInterfaceToClassIntention
extends Intention {
    private static void changeInterfaceToClass(PsiClass anInterface) throws IncorrectOperationException {
        PsiClass[] innerClasses;
        PsiField[] fields;
        PsiMethod[] methods;
        PsiIdentifier nameIdentifier = anInterface.getNameIdentifier();
        assert (nameIdentifier != null);
        PsiElement whiteSpace = nameIdentifier.getPrevSibling();
        assert (whiteSpace != null);
        PsiElement interfaceToken = whiteSpace.getPrevSibling();
        assert (interfaceToken != null);
        PsiKeyword interfaceKeyword = (PsiKeyword)interfaceToken.getOriginalElement();
        Project project2 = anInterface.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiKeyword classKeyword = factory.createKeyword("class");
        interfaceKeyword.replace((PsiElement)classKeyword);
        PsiModifierList classModifierList = anInterface.getModifierList();
        if (classModifierList == null) {
            return;
        }
        classModifierList.setModifierProperty("abstract", true);
        PsiElement parent = anInterface.getParent();
        if (parent instanceof PsiClass) {
            classModifierList.setModifierProperty("static", true);
        }
        for (PsiMethod method : methods = anInterface.getMethods()) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"public", (boolean)true);
            if (method.hasModifierProperty("default")) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"default", (boolean)false);
                continue;
            }
            if (method.hasModifierProperty("static")) continue;
            PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"abstract", (boolean)true);
        }
        for (PsiField field : fields = anInterface.getFields()) {
            PsiModifierList modifierList = field.getModifierList();
            if (modifierList == null) continue;
            modifierList.setModifierProperty("public", true);
            modifierList.setModifierProperty("static", true);
            modifierList.setModifierProperty("final", true);
        }
        for (PsiClass innerClass : innerClasses = anInterface.getInnerClasses()) {
            PsiModifierList modifierList = innerClass.getModifierList();
            if (modifierList == null) continue;
            modifierList.setModifierProperty("public", true);
            if (innerClass.isInterface()) continue;
            modifierList.setModifierProperty("static", true);
        }
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        boolean conflictsDialogOK;
        final PsiClass anInterface = (PsiClass)element.getParent();
        SearchScope searchScope = anInterface.getUseScope();
        Query query = ClassInheritorsSearch.search((PsiClass)anInterface, (SearchScope)searchScope, (boolean)false);
        final MultiMap conflicts = new MultiMap();
        query.forEach((Processor)new Processor<PsiClass>(){

            public boolean process(PsiClass aClass) {
                PsiElement target;
                PsiReferenceList extendsList = aClass.getExtendsList();
                if (extendsList == null) {
                    return true;
                }
                PsiJavaCodeReferenceElement[] referenceElements = extendsList.getReferenceElements();
                if (referenceElements.length > 0 && (target = referenceElements[0].resolve()) != null) {
                    conflicts.putValue((Object)aClass, (Object)IntentionPowerPackBundle.message("0.already.extends.1.and.will.not.compile.after.converting.2.to.a.class", RefactoringUIUtil.getDescription((PsiElement)aClass, true), RefactoringUIUtil.getDescription(target, true), RefactoringUIUtil.getDescription((PsiElement)anInterface, false)));
                }
                return true;
            }
        });
        PsiFunctionalExpression functionalExpression = (PsiFunctionalExpression)FunctionalExpressionSearch.search((PsiClass)anInterface, (SearchScope)searchScope).findFirst();
        if (functionalExpression != null) {
            String conflictMessage = ClassPresentationUtil.getFunctionalExpressionPresentation(functionalExpression, true) + " will not compile after converting " + RefactoringUIUtil.getDescription((PsiElement)anInterface, false) + " to a class";
            conflicts.putValue((Object)functionalExpression, (Object)conflictMessage);
        }
        if (conflicts.isEmpty()) {
            conflictsDialogOK = true;
        } else {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts.values());
            }
            ConflictsDialog conflictsDialog = new ConflictsDialog(anInterface.getProject(), (MultiMap<PsiElement, String>)conflicts, new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            ConvertInterfaceToClassIntention.convertInterfaceToClass(anInterface);
                        }
                    });
                }
            });
            conflictsDialogOK = conflictsDialog.showAndGet();
        }
        if (conflictsDialogOK) {
            ConvertInterfaceToClassIntention.convertInterfaceToClass(anInterface);
        }
    }

    private static void convertInterfaceToClass(PsiClass anInterface) {
        boolean success = ConvertInterfaceToClassIntention.moveSubClassImplementsToExtends(anInterface);
        if (!success) {
            return;
        }
        ConvertInterfaceToClassIntention.changeInterfaceToClass(anInterface);
        ConvertInterfaceToClassIntention.moveExtendsToImplements(anInterface);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new ConvertInterfaceToClassPredicate();
    }

    private static void moveExtendsToImplements(PsiClass anInterface) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement[] extendsRefElements;
        PsiReferenceList extendsList = anInterface.getExtendsList();
        PsiReferenceList implementsList = anInterface.getImplementsList();
        assert (extendsList != null);
        for (PsiJavaCodeReferenceElement referenceElement : extendsRefElements = extendsList.getReferenceElements()) {
            assert (implementsList != null);
            PsiElement resolved = referenceElement.resolve();
            if (!(resolved instanceof PsiClass) || !((PsiClass)resolved).isInterface()) continue;
            implementsList.add((PsiElement)referenceElement);
            referenceElement.delete();
        }
    }

    private static boolean moveSubClassImplementsToExtends(PsiClass oldInterface) throws IncorrectOperationException {
        Project project2 = oldInterface.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiElementFactory elementFactory = psiFacade.getElementFactory();
        PsiJavaCodeReferenceElement oldInterfaceReference = elementFactory.createClassReferenceElement(oldInterface);
        SearchScope searchScope = oldInterface.getUseScope();
        Query query = ClassInheritorsSearch.search((PsiClass)oldInterface, (SearchScope)searchScope, (boolean)false);
        Collection inheritors = query.findAll();
        boolean success = CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project2, (Collection)inheritors, (boolean)false);
        if (!success) {
            return false;
        }
        for (PsiClass inheritor : inheritors) {
            PsiReferenceList implementsList = inheritor.getImplementsList();
            PsiReferenceList extendsList = inheritor.getExtendsList();
            if (implementsList == null) continue;
            ConvertInterfaceToClassIntention.moveReference(implementsList, extendsList, oldInterfaceReference);
        }
        return true;
    }

    private static void moveReference(@NotNull PsiReferenceList source, @Nullable PsiReferenceList target, @NotNull PsiJavaCodeReferenceElement reference) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement[] implementsReferences = source.getReferenceElements();
        String qualifiedName = reference.getQualifiedName();
        for (PsiJavaCodeReferenceElement implementsReference : implementsReferences) {
            String implementsReferenceQualifiedName = implementsReference.getQualifiedName();
            if (!qualifiedName.equals(implementsReferenceQualifiedName)) continue;
            if (target != null) {
                target.add((PsiElement)implementsReference);
            }
            implementsReference.delete();
        }
    }
}

