/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.integer;

import com.intellij.psi.PsiType;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.integer.ConvertIntegerToBinaryPredicate;
import com.siyeh.ipp.integer.ConvertNumberIntentionBase;
import org.jetbrains.annotations.NotNull;

public class ConvertIntegerToBinaryIntention
extends ConvertNumberIntentionBase {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new ConvertIntegerToBinaryPredicate();
    }

    @Override
    protected String convertValue(Number value, PsiType type, boolean negated) {
        if (PsiType.INT.equals((Object)type)) {
            int intValue = negated ? -value.intValue() : value.intValue();
            return "0b" + Integer.toBinaryString(intValue);
        }
        if (PsiType.LONG.equals((Object)type)) {
            long longValue = negated ? -value.longValue() : value.longValue();
            return "0b" + Long.toBinaryString(longValue) + "L";
        }
        return null;
    }
}

