/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.initialization;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.util.RefactoringUtil;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.initialization.SplitDeclarationAndInitializationPredicate;
import com.siyeh.ipp.psiutils.HighlightUtil;
import org.jetbrains.annotations.NotNull;

public class SplitDeclarationAndInitializationIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new SplitDeclarationAndInitializationPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiModifierList modifierList;
        PsiField field = (PsiField)element.getParent();
        PsiExpression initializer = field.getInitializer();
        if (initializer == null) {
            return;
        }
        String initializerText = RefactoringUtil.convertInitializerToNormalExpression(initializer, field.getType()).getText();
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return;
        }
        boolean fieldIsStatic = field.hasModifierProperty("static");
        PsiClassInitializer[] classInitializers = containingClass.getInitializers();
        PsiClassInitializer classInitializer = null;
        int fieldOffset = field.getTextOffset();
        for (PsiClassInitializer existingClassInitializer : classInitializers) {
            boolean initializerIsStatic;
            int initializerOffset = existingClassInitializer.getTextOffset();
            if (initializerOffset <= fieldOffset || (initializerIsStatic = existingClassInitializer.hasModifierProperty("static")) != fieldIsStatic) continue;
            classInitializer = existingClassInitializer;
            break;
        }
        PsiManager manager = field.getManager();
        Project project2 = manager.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        if (classInitializer == null) {
            classInitializer = elementFactory.createClassInitializer();
            classInitializer = (PsiClassInitializer)containingClass.addAfter((PsiElement)classInitializer, (PsiElement)field);
            PsiElement whitespace = PsiParserFacade.SERVICE.getInstance((Project)project2).createWhiteSpaceFromText("\n");
            containingClass.addAfter(whitespace, (PsiElement)field);
        }
        PsiCodeBlock body = classInitializer.getBody();
        String initializationStatementText = field.getName() + " = " + initializerText + ';';
        PsiExpressionStatement statement2 = (PsiExpressionStatement)elementFactory.createStatementFromText(initializationStatementText, (PsiElement)body);
        PsiElement addedElement = body.add((PsiElement)statement2);
        if (fieldIsStatic && (modifierList = classInitializer.getModifierList()) != null) {
            modifierList.setModifierProperty("static", true);
        }
        initializer.delete();
        CodeStyleManager.getInstance((Project)manager.getProject()).reformat((PsiElement)classInitializer);
        HighlightUtil.highlightElement(addedElement, IntentionPowerPackBundle.message("press.escape.to.remove.highlighting.message", new Object[0]));
    }
}

