/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.expression;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.expression.ExpressionPredicate;
import org.jetbrains.annotations.NotNull;

public class FlipExpressionIntention
extends MutablyNamedIntention {
    @Override
    public String getTextForElement(PsiElement element) {
        PsiExpression[] operands;
        PsiPolyadicExpression expression = (PsiPolyadicExpression)element.getParent();
        PsiJavaToken sign = expression.getTokenBeforeOperand((operands = expression.getOperands())[1]);
        String operatorText = sign == null ? "" : sign.getText();
        IElementType tokenType = expression.getOperationTokenType();
        boolean commutative = ParenthesesUtils.isCommutativeOperator(tokenType);
        if (commutative && !ExpressionUtils.isConcatenation((PsiElement)expression)) {
            return IntentionPowerPackBundle.message("flip.smth.intention.name", operatorText);
        }
        return IntentionPowerPackBundle.message("flip.smth.intention.name1", operatorText);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new ExpressionPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiJavaToken token = (PsiJavaToken)element;
        PsiElement parent = token.getParent();
        if (!(parent instanceof PsiPolyadicExpression)) {
            return;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
        PsiExpression[] operands = polyadicExpression.getOperands();
        StringBuilder newExpression = new StringBuilder();
        String prevOperand = null;
        String tokenText = token.getText() + ' ';
        for (PsiExpression operand : operands) {
            PsiJavaToken token1 = polyadicExpression.getTokenBeforeOperand(operand);
            if (token == token1) {
                newExpression.append(operand.getText()).append(tokenText);
                continue;
            }
            if (prevOperand != null) {
                newExpression.append(prevOperand).append(tokenText);
            }
            prevOperand = operand.getText();
        }
        newExpression.append(prevOperand);
        PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, newExpression.toString());
    }

    @Override
    protected void processIntention(Editor editor, @NotNull PsiElement element) {
        CaretModel caretModel = editor.getCaretModel();
        int offset = caretModel.getOffset();
        super.processIntention(editor, element);
        caretModel.moveToOffset(offset);
    }
}

