/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ipp.base.PsiElementPredicate;

class TryWithMultipleResourcesPredicate
implements PsiElementPredicate {
    TryWithMultipleResourcesPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiJavaToken javaToken;
        IElementType tokenType;
        if (element instanceof PsiJavaToken ? !JavaTokenType.TRY_KEYWORD.equals(tokenType = (javaToken = (PsiJavaToken)element).getTokenType()) : !(element instanceof PsiResourceList)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiTryStatement)) {
            return false;
        }
        PsiTryStatement tryStatement = (PsiTryStatement)parent;
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList == null) {
            return false;
        }
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock == null) {
            return false;
        }
        return resourceList.getResourceVariablesCount() > 1;
    }
}

