/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExceptionUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.exceptions.DetailExceptionsPredicate;
import com.siyeh.ipp.exceptions.HierarchicalTypeComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class DetailExceptionsIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new DetailExceptionsPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiCatchSection[] catchSections;
        PsiCodeBlock tryBlock;
        PsiJavaToken token = (PsiJavaToken)element;
        PsiElement parent = token.getParent();
        if (parent instanceof PsiCatchSection) {
            parent = parent.getParent();
        }
        if (!(parent instanceof PsiTryStatement)) {
            return;
        }
        PsiTryStatement tryStatement = (PsiTryStatement)parent;
        StringBuilder newTryStatement = new StringBuilder("try");
        HashSet<PsiType> exceptionsThrown = new HashSet<PsiType>();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList != null) {
            newTryStatement.append(resourceList.getText());
            ExceptionUtils.calculateExceptionsThrown((PsiElement)resourceList, exceptionsThrown);
        }
        if ((tryBlock = tryStatement.getTryBlock()) == null) {
            return;
        }
        String tryBlockText = tryBlock.getText();
        newTryStatement.append(tryBlockText);
        ExceptionUtils.calculateExceptionsThrown((PsiElement)tryBlock, exceptionsThrown);
        HierarchicalTypeComparator comparator2 = new HierarchicalTypeComparator();
        ArrayList<PsiType> exceptionsAlreadyEmitted = new ArrayList<PsiType>();
        for (PsiCatchSection catchSection : catchSections = tryStatement.getCatchSections()) {
            PsiParameter parameter = catchSection.getParameter();
            PsiCodeBlock block = catchSection.getCatchBlock();
            if (parameter == null || block == null) continue;
            PsiType caughtType = parameter.getType();
            ArrayList<PsiType> exceptionsToExpand = new ArrayList<PsiType>(10);
            for (Object e : exceptionsThrown) {
                PsiType thrownType = (PsiType)e;
                if (!caughtType.isAssignableFrom(thrownType)) continue;
                exceptionsToExpand.add(thrownType);
            }
            exceptionsToExpand.removeAll(exceptionsAlreadyEmitted);
            Collections.sort(exceptionsToExpand, comparator2);
            for (PsiType psiType : exceptionsToExpand) {
                newTryStatement.append("catch(").append(psiType.getCanonicalText()).append(' ').append(parameter.getName()).append(')');
                newTryStatement.append(block.getText());
                exceptionsAlreadyEmitted.add(psiType);
            }
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            newTryStatement.append("finally").append(finallyBlock.getText());
        }
        String newStatement = newTryStatement.toString();
        PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)tryStatement, newStatement);
    }
}

