/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.VariableSearchUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.exceptions.ConvertCatchToThrowsPredicate;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ConvertCatchToThrowsIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new ConvertCatchToThrowsPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiMethod method;
        PsiCatchSection catchSection = (PsiCatchSection)element.getParent();
        NavigatablePsiElement owner = (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)catchSection, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
        if (owner instanceof PsiMethod) {
            method = (PsiMethod)owner;
        } else if (owner instanceof PsiLambdaExpression) {
            method = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)owner);
            if (method == null || !FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{method})) {
                return;
            }
        } else {
            return;
        }
        PsiReferenceList throwsList = method.getThrowsList();
        PsiType catchType = catchSection.getCatchType();
        ConvertCatchToThrowsIntention.addToThrowsList(throwsList, catchType);
        PsiTryStatement tryStatement = catchSection.getTryStatement();
        PsiCatchSection[] catchSections = tryStatement.getCatchSections();
        if (catchSections.length > 1 || tryStatement.getResourceList() != null || tryStatement.getFinallyBlock() != null) {
            catchSection.delete();
        } else {
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            PsiCodeBlock parentCodeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)tryStatement, PsiCodeBlock.class);
            if (parentCodeBlock == null || !VariableSearchUtils.containsConflictingDeclarations(tryBlock, parentCodeBlock)) {
                PsiElement first = tryBlock.getFirstBodyElement();
                PsiElement last = tryBlock.getLastBodyElement();
                if (first != null && last != null) {
                    tryStatement.getParent().addRangeAfter(first, last, (PsiElement)tryStatement);
                }
                tryStatement.delete();
            } else {
                tryStatement.replace((PsiElement)tryBlock);
            }
        }
    }

    private static void addToThrowsList(PsiReferenceList throwsList, PsiType catchType) {
        if (catchType instanceof PsiClassType) {
            PsiClassType[] types;
            PsiClassType classType = (PsiClassType)catchType;
            for (PsiClassType type : types = throwsList.getReferencedTypes()) {
                if (!catchType.equals(type)) continue;
                return;
            }
            Project project2 = throwsList.getProject();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            PsiJavaCodeReferenceElement referenceElement = factory.createReferenceElementByType(classType);
            throwsList.add((PsiElement)referenceElement);
        } else if (catchType instanceof PsiDisjunctionType) {
            PsiDisjunctionType disjunctionType = (PsiDisjunctionType)catchType;
            List disjunctions = disjunctionType.getDisjunctions();
            for (PsiType disjunction : disjunctions) {
                ConvertCatchToThrowsIntention.addToThrowsList(throwsList, disjunction);
            }
        }
    }
}

