/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.equality;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.equality.ObjectEqualityPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceEqualityWithEqualsIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)element;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (JavaTokenType.NE.equals(tokenType)) {
            return IntentionPowerPackBundle.message("replace.equality.with.not.equals.intention.name", new Object[0]);
        }
        return IntentionPowerPackBundle.message("replace.equality.with.equals.intention.name", new Object[0]);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new ObjectEqualityPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiBinaryExpression exp = (PsiBinaryExpression)element;
        PsiExpression lhs = exp.getLOperand();
        PsiExpression rhs = exp.getROperand();
        if (rhs == null) {
            return;
        }
        PsiExpression strippedLhs = ParenthesesUtils.stripParentheses(lhs);
        if (strippedLhs == null) {
            return;
        }
        PsiExpression strippedRhs = ParenthesesUtils.stripParentheses(rhs);
        if (strippedRhs == null) {
            return;
        }
        String lhText = strippedLhs.getText();
        String rhText = strippedRhs.getText();
        String prefix = exp.getOperationTokenType().equals(JavaTokenType.EQEQ) ? "" : "!";
        String expString = ParenthesesUtils.getPrecedence(strippedLhs) > 1 ? prefix + '(' + lhText + ").equals(" + rhText + ')' : prefix + lhText + ".equals(" + rhText + ')';
        PsiReplacementUtil.replaceExpression((PsiExpression)exp, expString);
    }
}

