/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.enumswitch;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;
import java.util.HashSet;

class EnumSwitchPredicate
implements PsiElementPredicate {
    EnumSwitchPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiStatement[] statements;
        PsiElement prevSibling;
        if (element instanceof PsiWhiteSpace && (prevSibling = element.getPrevSibling()) instanceof PsiSwitchStatement && ErrorUtil.containsError(prevSibling)) {
            element = prevSibling;
        }
        if (!(element instanceof PsiSwitchStatement)) {
            return false;
        }
        PsiSwitchStatement switchStatement = (PsiSwitchStatement)element;
        PsiExpression expression = switchStatement.getExpression();
        if (expression == null) {
            return false;
        }
        PsiType type = expression.getType();
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClass enumClass = ((PsiClassType)type).resolve();
        if (enumClass == null || !enumClass.isEnum()) {
            return false;
        }
        PsiField[] fields = enumClass.getFields();
        if (fields.length == 0) {
            return false;
        }
        PsiCodeBlock body = switchStatement.getBody();
        if (body == null) {
            return true;
        }
        HashSet<String> enumElements = new HashSet<String>(fields.length);
        for (PsiField field : fields) {
            PsiType fieldType = field.getType();
            if (!fieldType.equals(type)) continue;
            String fieldName = field.getName();
            enumElements.add(fieldName);
        }
        for (PsiStatement statement2 : statements = body.getStatements()) {
            PsiSwitchLabelStatement labelStatement;
            PsiExpression value;
            if (!(statement2 instanceof PsiSwitchLabelStatement) || (value = (labelStatement = (PsiSwitchLabelStatement)statement2).getCaseValue()) == null) continue;
            String valueText = value.getText();
            enumElements.remove(valueText);
        }
        return !enumElements.isEmpty();
    }
}

