/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.constant;

import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ConstantEvaluationOverflowException;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.PsiElementPredicate;

class ConstantExpressionPredicate
implements PsiElementPredicate {
    ConstantExpressionPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiExpression[] operands;
        if (!(element instanceof PsiPolyadicExpression)) {
            return false;
        }
        if (element instanceof PsiLiteralExpression || element instanceof PsiClassObjectAccessExpression) {
            return false;
        }
        PsiPolyadicExpression expression = (PsiPolyadicExpression)element;
        PsiType expressionType = expression.getType();
        if (expressionType == null || expressionType.equalsToText("java.lang.String")) {
            return false;
        }
        for (PsiExpression operand : operands = expression.getOperands()) {
            if (operand == null) {
                return false;
            }
            PsiType type = operand.getType();
            if (type != null && !type.equalsToText("java.lang.String")) continue;
            return false;
        }
        if (!PsiUtil.isConstantExpression((PsiExpression)expression)) {
            return false;
        }
        try {
            Object value = ExpressionUtils.computeConstantExpression((PsiExpression)expression, true);
            if (value == null) {
                return false;
            }
        }
        catch (ConstantEvaluationOverflowException ignore) {
            return false;
        }
        PsiElement parent = element.getParent();
        return !(parent instanceof PsiExpression) || !PsiUtil.isConstantExpression((PsiExpression)((PsiExpression)parent));
    }
}

