/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.constant;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.constant.ConstantExpressionPredicate;
import com.siyeh.ipp.psiutils.HighlightUtil;
import org.jetbrains.annotations.NotNull;

public class ConstantExpressionIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        String text = HighlightUtil.getPresentableText(element);
        return IntentionPowerPackBundle.message("constant.expression.intention.name", text);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new ConstantExpressionPredicate();
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        String newExpression;
        PsiExpression expression = (PsiExpression)element;
        Object value = ExpressionUtils.computeConstantExpression(expression);
        if (value instanceof String) {
            String string = (String)value;
            newExpression = '\"' + StringUtil.escapeStringCharacters((String)string) + '\"';
        } else {
            double v;
            newExpression = value instanceof Character ? '\'' + StringUtil.escapeStringCharacters((String)value.toString()) + '\'' : (value instanceof Long ? value.toString() + 'L' : (value instanceof Double ? (Double.isNaN(v = ((Double)value).doubleValue()) ? "java.lang.Double.NaN" : (Double.isInfinite(v) ? (v > 0.0 ? "java.lang.Double.POSITIVE_INFINITY" : "java.lang.Double.NEGATIVE_INFINITY") : Double.toString(v))) : (value instanceof Float ? (Float.isNaN(v = ((Float)value).floatValue()) ? "java.lang.Float.NaN" : (Float.isInfinite(v) ? (v > 0.0f ? "java.lang.Float.POSITIVE_INFINITY" : "java.lang.Float.NEGATIVE_INFINITY") : Float.toString(v) + 'f')) : (value == null ? "null" : String.valueOf(value)))));
        }
        PsiReplacementUtil.replaceExpression(expression, newExpression);
    }
}

