/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.conditional;

import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.conditional.RemoveConditionalPredicate;
import org.jetbrains.annotations.NotNull;

public class RemoveConditionalIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new RemoveConditionalPredicate();
    }

    @Override
    public void processIntention(PsiElement element) {
        PsiConditionalExpression expression = (PsiConditionalExpression)element;
        PsiExpression condition = expression.getCondition();
        PsiExpression thenExpression = expression.getThenExpression();
        assert (thenExpression != null);
        String thenExpressionText = thenExpression.getText();
        if ("true".equals(thenExpressionText)) {
            String newExpression = condition.getText();
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, newExpression);
        } else {
            String newExpression = BoolUtils.getNegatedExpressionText(condition);
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, newExpression);
        }
    }
}

