/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.conditional;

import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.conditional.FlipConditionalPredicate;
import org.jetbrains.annotations.NotNull;

public class FlipConditionalIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new FlipConditionalPredicate();
    }

    @Override
    public void processIntention(PsiElement element) {
        PsiConditionalExpression exp = (PsiConditionalExpression)element;
        PsiExpression condition = exp.getCondition();
        PsiExpression elseExpression = exp.getElseExpression();
        PsiExpression thenExpression = exp.getThenExpression();
        assert (elseExpression != null);
        assert (thenExpression != null);
        String newExpression = BoolUtils.getNegatedExpressionText(condition) + '?' + elseExpression.getText() + ':' + thenExpression.getText();
        PsiReplacementUtil.replaceExpression((PsiExpression)exp, newExpression);
    }
}

