/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.concatenation.SimpleStringConcatenationPredicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ReplaceConcatenationWithStringBufferIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)element)) {
            return IntentionPowerPackBundle.message("replace.concatenation.with.string.builder.intention.name", new Object[0]);
        }
        return IntentionPowerPackBundle.message("replace.concatenation.with.string.buffer.intention.name", new Object[0]);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new SimpleStringConcatenationPredicate(true);
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiPolyadicExpression expression = (PsiPolyadicExpression)element;
        PsiElement parent = expression.getParent();
        while (ExpressionUtils.isConcatenation(parent)) {
            expression = (PsiPolyadicExpression)parent;
            parent = expression.getParent();
        }
        StringBuilder newExpression = new StringBuilder();
        if (ReplaceConcatenationWithStringBufferIntention.isPartOfStringBufferAppend((PsiExpression)expression)) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)parent.getParent();
            assert (methodCallExpression != null);
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression != null) {
                String qualifierText = qualifierExpression.getText();
                newExpression.append(qualifierText);
            }
            ReplaceConcatenationWithStringBufferIntention.turnExpressionIntoChainedAppends((PsiExpression)expression, newExpression);
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, newExpression.toString());
        } else {
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)expression)) {
                newExpression.append("new StringBuffer()");
            } else {
                newExpression.append("new StringBuilder()");
            }
            ReplaceConcatenationWithStringBufferIntention.turnExpressionIntoChainedAppends((PsiExpression)expression, newExpression);
            newExpression.append(".toString()");
            PsiReplacementUtil.replaceExpression((PsiExpression)expression, newExpression.toString());
        }
    }

    private static boolean isPartOfStringBufferAppend(PsiExpression expression) {
        PsiElement parent = expression.getParent();
        if (!(parent instanceof PsiExpressionList)) {
            return false;
        }
        if (!((parent = parent.getParent()) instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)parent;
        PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
        PsiType type = methodExpression.getType();
        if (type == null) {
            return false;
        }
        String className = type.getCanonicalText();
        if (!"java.lang.StringBuffer".equals(className) && !"java.lang.StringBuilder".equals(className)) {
            return false;
        }
        String methodName = methodExpression.getReferenceName();
        return "append".equals(methodName);
    }

    private static void turnExpressionIntoChainedAppends(PsiExpression expression, @NonNls StringBuilder result) {
        if (expression instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression concatenation = (PsiPolyadicExpression)expression;
            PsiType type = concatenation.getType();
            if (type != null && !type.equalsToText("java.lang.String")) {
                result.append(".append(").append(concatenation.getText()).append(')');
                return;
            }
            PsiExpression[] operands = concatenation.getOperands();
            PsiType startType = operands[0].getType();
            if (startType == null || startType.equalsToText("java.lang.String")) {
                for (PsiExpression operand : operands) {
                    ReplaceConcatenationWithStringBufferIntention.turnExpressionIntoChainedAppends(operand, result);
                }
                return;
            }
            StringBuilder newExpressionText = new StringBuilder(operands[0].getText());
            boolean string = false;
            for (int i = 1; i < operands.length; ++i) {
                PsiExpression operand = operands[i];
                if (!string) {
                    PsiType operandType = operand.getType();
                    if (operandType == null || operandType.equalsToText("java.lang.String")) {
                        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression.getProject());
                        PsiExpression newExpression = factory.createExpressionFromText(newExpressionText.toString(), (PsiElement)expression);
                        ReplaceConcatenationWithStringBufferIntention.turnExpressionIntoChainedAppends(newExpression, result);
                        ReplaceConcatenationWithStringBufferIntention.turnExpressionIntoChainedAppends(operand, result);
                        string = true;
                    }
                    newExpressionText.append('+').append(operand.getText());
                    continue;
                }
                ReplaceConcatenationWithStringBufferIntention.turnExpressionIntoChainedAppends(operand, result);
            }
        } else {
            PsiExpression strippedExpression = ParenthesesUtils.stripParentheses(expression);
            result.append(".append(");
            if (strippedExpression != null) {
                result.append(strippedExpression.getText());
            }
            result.append(')');
        }
    }
}

