/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.concatenation.StringConcatPredicate;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JoinConcatenatedStringLiteralsIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new StringConcatPredicate();
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        if (element instanceof PsiWhiteSpace) {
            element = element.getPrevSibling();
        }
        if (!(element instanceof PsiJavaToken)) {
            return;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)element.getParent();
        StringBuilder newExpression = new StringBuilder();
        PsiElement[] children2 = polyadicExpression.getChildren();
        ArrayList<PsiElement> buffer = new ArrayList<PsiElement>(3);
        for (PsiElement child : children2) {
            Object value;
            PsiLiteralExpression literalExpression;
            if (child instanceof PsiJavaToken) {
                if (token.equals(child)) {
                    literalExpression = (PsiLiteralExpression)buffer.get(0);
                    value = literalExpression.getValue();
                    assert (value != null);
                    newExpression.append('\"').append(StringUtil.escapeStringCharacters((String)value.toString()));
                    continue;
                }
                for (PsiElement bufferedElement : buffer) {
                    newExpression.append(bufferedElement.getText());
                }
                buffer.clear();
                newExpression.append(child.getText());
                continue;
            }
            if (child instanceof PsiLiteralExpression) {
                if (buffer.isEmpty()) {
                    buffer.add(child);
                    continue;
                }
                literalExpression = (PsiLiteralExpression)child;
                value = literalExpression.getValue();
                assert (value != null);
                newExpression.append(StringUtil.escapeStringCharacters((String)value.toString())).append('\"');
                buffer.clear();
                continue;
            }
            if (buffer.isEmpty()) {
                newExpression.append(child.getText());
                continue;
            }
            buffer.add(child);
        }
        for (PsiElement bufferedElement : buffer) {
            newExpression.append(bufferedElement.getText());
        }
        PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, newExpression.toString());
    }
}

