/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.concatenation.SimpleStringConcatenationPredicate;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.NotNull;

public class CopyConcatenatedStringToClipboardIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new SimpleStringConcatenationPredicate(false);
    }

    @Override
    protected boolean prepareForWriting() {
        return false;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (!(element instanceof PsiPolyadicExpression)) {
            return;
        }
        PsiPolyadicExpression concatenationExpression = (PsiPolyadicExpression)element;
        IElementType tokenType = concatenationExpression.getOperationTokenType();
        if (tokenType != JavaTokenType.PLUS) {
            return;
        }
        PsiType type = concatenationExpression.getType();
        if (type == null || !type.equalsToText("java.lang.String")) {
            return;
        }
        StringBuilder text = CopyConcatenatedStringToClipboardIntention.buildConcatenationText(concatenationExpression, new StringBuilder());
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text.toString()));
    }

    private static StringBuilder buildConcatenationText(PsiPolyadicExpression polyadicExpression, StringBuilder out) {
        for (PsiElement element : polyadicExpression.getChildren()) {
            if (element instanceof PsiExpression) {
                PsiExpression expression = (PsiExpression)element;
                Object value = ExpressionUtils.computeConstantExpression(expression);
                if (value == null) {
                    out.append('?');
                    continue;
                }
                out.append(value.toString());
                continue;
            }
            if (!(element instanceof PsiWhiteSpace) || !element.getText().contains("\n") || out.length() != 0 && out.charAt(out.length() - 1) == '\n') continue;
            out.append('\n');
        }
        return out;
    }
}

