/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.comment;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.comment.CommentOnLineWithSourcePredicate;
import org.jetbrains.annotations.NotNull;

public class MoveCommentToSeparateLineIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new CommentOnLineWithSourcePredicate();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        void var4_4;
        PsiComment selectedComment;
        PsiComment elementToCheck = selectedComment = (PsiComment)element;
        do {
            if ((elementToCheck = PsiTreeUtil.prevLeaf((PsiElement)elementToCheck)) != null) continue;
            return;
        } while (!MoveCommentToSeparateLineIntention.isLineBreakWhiteSpace((PsiElement)elementToCheck));
        PsiWhiteSpace whiteSpace = (PsiWhiteSpace)elementToCheck;
        PsiElement copyWhiteSpace = var4_4.copy();
        PsiElement parent = var4_4.getParent();
        assert (parent != null);
        PsiManager manager = selectedComment.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        String commentText = selectedComment.getText();
        PsiComment newComment = factory.createCommentFromText(commentText, parent);
        PsiElement insertedComment = parent.addBefore((PsiElement)newComment, (PsiElement)var4_4);
        parent.addBefore(copyWhiteSpace, insertedComment);
        selectedComment.delete();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
        codeStyleManager.reformat(insertedComment);
    }

    private static boolean isLineBreakWhiteSpace(PsiElement element) {
        if (!(element instanceof PsiWhiteSpace)) {
            return false;
        }
        String text = element.getText();
        return MoveCommentToSeparateLineIntention.containsLineBreak(text);
    }

    private static boolean containsLineBreak(String text) {
        return text.indexOf(10) >= 0 || text.indexOf(13) >= 0;
    }
}

