/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.comment;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.comment.EndOfLineCommentPredicate;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ChangeToCStyleCommentIntention
extends Intention {
    private static final Class<PsiWhiteSpace>[] WHITESPACE_CLASS = new Class[]{PsiWhiteSpace.class};

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new EndOfLineCommentPredicate();
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        String newCommentString;
        CharSequence text;
        PsiElement prevComment;
        PsiComment firstComment = (PsiComment)element;
        while (ChangeToCStyleCommentIntention.isEndOfLineComment(prevComment = PsiTreeUtil.skipSiblingsBackward((PsiElement)firstComment, (Class[])WHITESPACE_CLASS))) {
            assert (prevComment != null);
            firstComment = (PsiComment)prevComment;
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)element.getProject());
        PsiElementFactory factory = psiFacade.getElementFactory();
        ArrayList<PsiComment> multiLineComments = new ArrayList<PsiComment>();
        PsiComment nextComment = firstComment;
        String whiteSpace = null;
        while (ChangeToCStyleCommentIntention.isEndOfLineComment((PsiElement)(nextComment = PsiTreeUtil.skipSiblingsForward((PsiElement)nextComment, (Class[])WHITESPACE_CLASS)))) {
            assert (nextComment != null);
            if (whiteSpace == null) {
                PsiElement prevSibling = nextComment.getPrevSibling();
                assert (prevSibling != null);
                text = prevSibling.getText();
                whiteSpace = ChangeToCStyleCommentIntention.getIndent((String)text);
            }
            multiLineComments.add(nextComment);
        }
        if (multiLineComments.isEmpty()) {
            text = ChangeToCStyleCommentIntention.getCommentContents(firstComment);
            newCommentString = "/* " + (String)text + " */";
        } else {
            text = new StringBuilder();
            ((StringBuilder)text).append("/*\n");
            ((StringBuilder)text).append(whiteSpace);
            ((StringBuilder)text).append(ChangeToCStyleCommentIntention.getCommentContents(firstComment));
            for (PsiComment psiComment : multiLineComments) {
                ((StringBuilder)text).append('\n');
                ((StringBuilder)text).append(whiteSpace);
                ((StringBuilder)text).append(ChangeToCStyleCommentIntention.getCommentContents(psiComment));
            }
            ((StringBuilder)text).append('\n');
            ((StringBuilder)text).append(whiteSpace);
            ((StringBuilder)text).append("*/");
            newCommentString = ((StringBuilder)text).toString();
        }
        PsiComment newComment = factory.createCommentFromText(newCommentString, element);
        firstComment.replace((PsiElement)newComment);
        for (PsiElement psiElement : multiLineComments) {
            psiElement.delete();
        }
    }

    private static String getIndent(String whitespace) {
        for (int i = whitespace.length() - 1; i >= 0; --i) {
            char c = whitespace.charAt(i);
            if (c != '\n') continue;
            if (i == whitespace.length() - 1) {
                return "";
            }
            return whitespace.substring(i + 1);
        }
        return whitespace;
    }

    private static boolean isEndOfLineComment(PsiElement element) {
        if (!(element instanceof PsiComment)) {
            return false;
        }
        PsiComment comment = (PsiComment)element;
        IElementType tokenType = comment.getTokenType();
        return JavaTokenType.END_OF_LINE_COMMENT.equals(tokenType);
    }

    private static String getCommentContents(@NotNull PsiComment comment) {
        String text = comment.getText();
        return StringUtil.replace((String)text.substring(2), (String)"*/", (String)"* /").trim();
    }
}

