/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.braces;

import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.braces.BaseBracesIntention;
import org.jetbrains.annotations.NotNull;

public class RemoveBracesIntention
extends BaseBracesIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                PsiStatement statement2 = BaseBracesIntention.getSurroundingStatement(element);
                if (statement2 == null || !(statement2 instanceof PsiBlockStatement)) {
                    return false;
                }
                PsiStatement[] statements = ((PsiBlockStatement)statement2).getCodeBlock().getStatements();
                if (statements.length != 1 || statements[0] instanceof PsiDeclarationStatement) {
                    return false;
                }
                PsiFile file2 = statement2.getContainingFile();
                return !FileTypeUtils.isInServerPageFile((PsiElement)file2);
            }
        };
    }

    @Override
    @NotNull
    protected String getMessageKey() {
        return "remove.braces.intention.name";
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiStatement body = RemoveBracesIntention.getSurroundingStatement(element);
        if (body == null || !(body instanceof PsiBlockStatement)) {
            return;
        }
        PsiBlockStatement blockStatement = (PsiBlockStatement)body;
        PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
        PsiStatement[] statements = codeBlock.getStatements();
        PsiStatement statement2 = statements[0];
        RemoveBracesIntention.handleComments(blockStatement, codeBlock);
        String text = statement2.getText();
        PsiReplacementUtil.replaceStatement((PsiStatement)blockStatement, text);
    }

    private static void handleComments(PsiBlockStatement blockStatement, PsiCodeBlock codeBlock) {
        PsiElement parent = blockStatement.getParent();
        assert (parent != null);
        PsiElement grandParent = parent.getParent();
        assert (grandParent != null);
        PsiElement sibling = codeBlock.getFirstChild();
        assert (sibling != null);
        for (sibling = sibling.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (!(sibling instanceof PsiComment)) continue;
            grandParent.addBefore(sibling, parent);
        }
        PsiElement lastChild = blockStatement.getLastChild();
        if (lastChild instanceof PsiComment) {
            PsiElement nextSibling = parent.getNextSibling();
            grandParent.addAfter(lastChild, nextSibling);
        }
    }
}

