/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.braces;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.MutablyNamedIntention;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseBracesIntention
extends MutablyNamedIntention {
    @Override
    protected final String getTextForElement(PsiElement element) {
        PsiStatement body = BaseBracesIntention.getSurroundingStatement(element);
        if (body == null) {
            return null;
        }
        return IntentionPowerPackBundle.message(this.getMessageKey(), BaseBracesIntention.getKeyword(body.getParent(), (PsiElement)body));
    }

    @NotNull
    protected abstract String getMessageKey();

    @NotNull
    private static String getKeyword(@NotNull PsiElement parent, @NotNull PsiElement element) {
        if (parent instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)parent;
            PsiStatement elseBranch = ifStatement.getElseBranch();
            return element.equals(elseBranch) ? "else" : "if";
        }
        PsiElement firstChild = parent.getFirstChild();
        assert (firstChild != null);
        return firstChild.getText();
    }

    @Nullable
    protected static PsiStatement getSurroundingStatement(@NotNull PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)parent;
            PsiStatement thenBranch = ifStatement.getThenBranch();
            int offset = element.getTextOffset();
            if (thenBranch != null && offset > thenBranch.getTextOffset()) {
                PsiKeyword elseElement = ifStatement.getElseElement();
                if (elseElement == null || offset < elseElement.getTextOffset()) {
                    return null;
                }
                return ifStatement.getElseBranch();
            }
            return thenBranch;
        }
        if (parent instanceof PsiLoopStatement) {
            return ((PsiLoopStatement)parent).getBody();
        }
        return null;
    }
}

