/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.braces;

import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.braces.BaseBracesIntention;
import org.jetbrains.annotations.NotNull;

public class AddBracesIntention
extends BaseBracesIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                PsiStatement statement2 = BaseBracesIntention.getSurroundingStatement(element);
                return statement2 != null && !(statement2 instanceof PsiBlockStatement);
            }
        };
    }

    @Override
    @NotNull
    protected String getMessageKey() {
        return "add.braces.intention.name";
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiStatement statement2 = AddBracesIntention.getSurroundingStatement(element);
        if (statement2 == null) {
            return;
        }
        String newStatement = "{\n" + statement2.getText() + "\n}";
        PsiReplacementUtil.replaceStatement(statement2, newStatement);
    }
}

