/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.bool;

import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;

public class NegateConditionalIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element) {
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element;
        String newExpression = conditionalExpression.getCondition().getText() + '?' + BoolUtils.getNegatedExpressionText(conditionalExpression.getThenExpression()) + ':' + BoolUtils.getNegatedExpressionText(conditionalExpression.getElseExpression());
        NegateConditionalIntention.replaceExpressionWithNegatedExpressionString(newExpression, (PsiExpression)conditionalExpression);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new BooleanConditionalExpressionPredicate();
    }

    private static class BooleanConditionalExpressionPredicate
    implements PsiElementPredicate {
        private BooleanConditionalExpressionPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element) {
            if (!(element instanceof PsiConditionalExpression)) {
                return false;
            }
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element;
            PsiType type = conditionalExpression.getType();
            return PsiType.BOOLEAN.equals((Object)type);
        }
    }
}

