/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.bool;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.bool.ComparisonPredicate;
import org.jetbrains.annotations.NotNull;

public class NegateComparisonIntention
extends MutablyNamedIntention {
    @Override
    public String getTextForElement(PsiElement element) {
        String operatorText = "";
        String negatedOperatorText = "";
        PsiBinaryExpression exp = (PsiBinaryExpression)element;
        if (exp != null) {
            PsiJavaToken sign = exp.getOperationSign();
            operatorText = sign.getText();
            negatedOperatorText = ComparisonUtils.getNegatedComparison(sign.getTokenType());
        }
        if (operatorText.equals(negatedOperatorText)) {
            return IntentionPowerPackBundle.message("negate.comparison.intention.name", operatorText);
        }
        return IntentionPowerPackBundle.message("negate.comparison.intention.name1", operatorText, negatedOperatorText);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new ComparisonPredicate();
    }

    @Override
    public void processIntention(PsiElement element) throws IncorrectOperationException {
        PsiBinaryExpression expression = (PsiBinaryExpression)element;
        PsiExpression lhs = expression.getLOperand();
        PsiExpression rhs = expression.getROperand();
        String negatedOperator = ComparisonUtils.getNegatedComparison(expression.getOperationTokenType());
        String lhsText = lhs.getText();
        assert (rhs != null);
        String rhsText = rhs.getText();
        NegateComparisonIntention.replaceExpressionWithNegatedExpressionString(lhsText + negatedOperator + rhsText, (PsiExpression)expression);
    }
}

