/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.bool;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.bool.ConjunctionPredicate;
import org.jetbrains.annotations.NotNull;

public class FlipConjunctionIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)element;
        PsiExpression op = binaryExpression.getOperands()[1];
        PsiJavaToken sign = binaryExpression.getTokenBeforeOperand(op);
        return IntentionPowerPackBundle.message("flip.smth.intention.name", sign.getText());
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new ConjunctionPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiExpression exp = (PsiExpression)element;
        PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)exp;
        IElementType conjunctionType = binaryExpression.getOperationTokenType();
        PsiElement parent = exp.getParent();
        while (FlipConjunctionIntention.isConjunctionExpression(parent, conjunctionType)) {
            exp = (PsiExpression)parent;
            assert (exp != null);
            parent = exp.getParent();
        }
        String newExpression = FlipConjunctionIntention.flipExpression(exp, conjunctionType);
        PsiReplacementUtil.replaceExpression(exp, newExpression);
    }

    private static String flipExpression(PsiExpression expression, IElementType conjunctionType) {
        if (!FlipConjunctionIntention.isConjunctionExpression((PsiElement)expression, conjunctionType)) {
            return expression.getText();
        }
        PsiPolyadicExpression andExpression = (PsiPolyadicExpression)expression;
        String conjunctionSign = conjunctionType.equals(JavaTokenType.ANDAND) ? "&&" : "||";
        String r = null;
        PsiExpression[] operands = andExpression.getOperands();
        for (int i = operands.length - 1; i >= 0; --i) {
            PsiExpression op = operands[i];
            String flip = FlipConjunctionIntention.flipExpression(op, conjunctionType);
            r = r == null ? flip : r + ' ' + conjunctionSign + ' ' + flip;
        }
        return r;
    }

    private static boolean isConjunctionExpression(PsiElement element, IElementType conjunctionType) {
        if (!(element instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)element;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        return tokenType.equals(conjunctionType);
    }
}

