/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.bool;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;

class BooleanLiteralEqualityPredicate
implements PsiElementPredicate {
    BooleanLiteralEqualityPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression expression = (PsiBinaryExpression)element;
        IElementType tokenType = expression.getOperationTokenType();
        if (!tokenType.equals(JavaTokenType.EQEQ) && !tokenType.equals(JavaTokenType.NE)) {
            return false;
        }
        PsiExpression lhs = expression.getLOperand();
        PsiExpression rhs = expression.getROperand();
        if (rhs == null) {
            return false;
        }
        if (!BoolUtils.isBooleanLiteral(lhs) && !BoolUtils.isBooleanLiteral(rhs)) {
            return false;
        }
        PsiType type = expression.getType();
        if (!PsiType.BOOLEAN.equals((Object)type)) {
            return false;
        }
        return !ErrorUtil.containsError(element);
    }
}

