/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.MethodSignature;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class MethodOverridesStaticMethodInspectionBase
extends BaseInspection {
    @NotNull
    public String getID() {
        return "MethodOverridesStaticMethodOfSuperclass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("method.overrides.static.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("method.overrides.static.problem.descriptor", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodOverridesStaticMethodVisitor();
    }

    private static class MethodOverridesStaticMethodVisitor
    extends BaseInspectionVisitor {
        private MethodOverridesStaticMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            String methodName = method.getName();
            MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
            HashSet<PsiClass> visitedClasses = new HashSet<PsiClass>();
            for (PsiClass ancestorClass = aClass.getSuperClass(); ancestorClass != null; ancestorClass = ancestorClass.getSuperClass()) {
                PsiMethod[] methods;
                if (!visitedClasses.add(ancestorClass)) {
                    return;
                }
                for (PsiMethod testMethod : methods = ancestorClass.findMethodsByName(methodName, false)) {
                    MethodSignature testSignature = testMethod.getSignature(PsiSubstitutor.EMPTY);
                    if (!signature.equals(testSignature) || !testMethod.hasModifierProperty("static") || testMethod.hasModifierProperty("private")) continue;
                    this.registerMethodError(method, new Object[0]);
                    return;
                }
            }
        }
    }
}

