/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class MethodOverridesPrivateMethodInspectionBase
extends BaseInspection {
    @NotNull
    public String getID() {
        return "MethodOverridesPrivateMethodOfSuperclass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("method.overrides.private.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("method.overrides.private.display.name.problem.descriptor", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodOverridesPrivateMethodVisitor();
    }

    private static class MethodOverridesPrivateMethodVisitor
    extends BaseInspectionVisitor {
        private MethodOverridesPrivateMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (JavaHighlightUtil.isSerializationRelatedMethod(method, aClass)) {
                return;
            }
            HashSet<PsiClass> visitedClasses = new HashSet<PsiClass>();
            for (PsiClass ancestorClass = aClass.getSuperClass(); ancestorClass != null; ancestorClass = ancestorClass.getSuperClass()) {
                if (!visitedClasses.add(ancestorClass)) {
                    return;
                }
                PsiMethod overridingMethod = ancestorClass.findMethodBySignature(method, false);
                if (overridingMethod == null || !overridingMethod.hasModifierProperty("private")) continue;
                this.registerMethodError(method, new Object[0]);
                return;
            }
        }
    }
}

