/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodOverloadsParentMethodInspectionBase
extends BaseInspection {
    public boolean reportIncompatibleParameters = false;

    @NotNull
    public String getID() {
        return "MethodOverloadsMethodOfSuperclass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("method.overloads.display.name", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("method.overloads.problem.descriptor", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("method.overloads.report.incompatible.option", new Object[0]), (InspectionProfileEntry)this, "reportIncompatibleParameters");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodOverloadsParentMethodVisitor();
    }

    private class MethodOverloadsParentMethodVisitor
    extends BaseInspectionVisitor {
        private MethodOverloadsParentMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method.hasModifierProperty("private") || method.hasModifierProperty("static")) {
                return;
            }
            if (method.getNameIdentifier() == null || method.isConstructor()) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (MethodUtils.hasSuper(method)) {
                return;
            }
            HashSet<PsiClass> visitedClasses = new HashSet<PsiClass>();
            this.processSupers(method, aClass, aClass, visitedClasses);
        }

        private boolean processSupers(PsiMethod method, PsiClass psiClass, PsiClass initialClass, Set<PsiClass> visitedClasses) {
            if (!visitedClasses.add(psiClass)) {
                return false;
            }
            if (initialClass != psiClass && this.methodOverloads(method, psiClass)) {
                this.registerMethodError(method, new Object[0]);
                return true;
            }
            if (PsiUtil.isLanguageLevel8OrHigher((PsiElement)method)) {
                for (PsiClass superClass : psiClass.getSupers()) {
                    if (!this.processSupers(method, superClass, initialClass, visitedClasses)) continue;
                    return true;
                }
            } else {
                PsiClass superClass = psiClass.getSuperClass();
                if (superClass != null) {
                    return this.processSupers(method, superClass, initialClass, visitedClasses);
                }
            }
            return false;
        }

        private boolean methodOverloads(PsiMethod method, PsiClass ancestorClass) {
            PsiMethod[] methods;
            String methodName = method.getName();
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            for (PsiMethod testMethod : methods = ancestorClass.findMethodsByName(methodName, false)) {
                PsiParameterList testParameterList;
                PsiParameter[] testParameters;
                if (testMethod.hasModifierProperty("private") || testMethod.hasModifierProperty("static") || testMethod.hasModifierProperty("abstract") || this.isOverriddenInClass(testMethod, method.getContainingClass()) || (testParameters = (testParameterList = testMethod.getParameterList()).getParameters()).length != parameters.length || !MethodOverloadsParentMethodInspectionBase.this.reportIncompatibleParameters && !this.parametersAreCompatible(parameters, testParameters)) continue;
                return true;
            }
            return false;
        }

        private boolean isOverriddenInClass(PsiMethod method, PsiClass aClass) {
            return aClass.findMethodsBySignature(method, false).length > 0;
        }

        private boolean parametersAreCompatible(PsiParameter[] parameters, PsiParameter[] testParameters) {
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter testParameter;
                PsiType testParameterType;
                PsiParameter parameter = parameters[i];
                PsiType parameterType = parameter.getType();
                if (parameterType.isAssignableFrom(testParameterType = (testParameter = testParameters[i]).getType()) || testParameterType.isAssignableFrom(parameterType)) continue;
                return false;
            }
            return true;
        }
    }
}

