/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalVariableHidingMemberVariableInspectionBase
extends BaseInspection {
    public boolean m_ignoreInvisibleFields = true;
    public boolean m_ignoreStaticMethods = true;

    @NotNull
    public String getID() {
        return "LocalVariableHidesMemberVariable";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("local.variable.hides.member.variable.display.name", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        return InspectionGadgetsBundle.message("local.variable.hides.member.variable.problem.descriptor", aClass.getName());
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("field.name.hides.in.superclass.ignore.option", new Object[0]), "m_ignoreInvisibleFields");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("local.variable.hides.member.variable.ignore.option", new Object[0]), "m_ignoreStaticMethods");
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LocalVariableHidingMemberVariableVisitor();
    }

    private class LocalVariableHidingMemberVariableVisitor
    extends BaseInspectionVisitor {
        private LocalVariableHidingMemberVariableVisitor() {
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            PsiMember member;
            super.visitLocalVariable(variable);
            if (LocalVariableHidingMemberVariableInspectionBase.this.m_ignoreStaticMethods && (member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiMethod.class, PsiClassInitializer.class})) != null && member.hasModifierProperty("static")) {
                return;
            }
            PsiClass aClass = this.checkFieldNames((PsiVariable)variable);
            if (aClass == null) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, aClass);
        }

        public void visitParameter(@NotNull PsiParameter variable) {
            PsiMember member;
            super.visitParameter(variable);
            PsiElement declarationScope = variable.getDeclarationScope();
            if (!(declarationScope instanceof PsiCatchSection) && !(declarationScope instanceof PsiForeachStatement)) {
                return;
            }
            if (LocalVariableHidingMemberVariableInspectionBase.this.m_ignoreStaticMethods && (member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiMethod.class, PsiClassInitializer.class})) != null && member.hasModifierProperty("static")) {
                return;
            }
            PsiClass aClass = this.checkFieldNames((PsiVariable)variable);
            if (aClass == null) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, aClass);
        }

        @Nullable
        private PsiClass checkFieldNames(PsiVariable variable) {
            PsiClass aClass = ClassUtils.getContainingClass((PsiElement)variable);
            String variableName = variable.getName();
            if (variableName == null) {
                return null;
            }
            while (aClass != null) {
                PsiField[] fields;
                for (PsiField field : fields = aClass.getAllFields()) {
                    String fieldName = field.getName();
                    if (!variableName.equals(fieldName) || LocalVariableHidingMemberVariableInspectionBase.this.m_ignoreInvisibleFields && !ClassUtils.isFieldVisible(field, aClass)) continue;
                    return aClass;
                }
                aClass = ClassUtils.getContainingClass((PsiElement)aClass);
            }
            return null;
        }
    }
}

