/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class InnerClassVariableHidesOuterClassVariableInspectionBase
extends BaseInspection {
    public boolean m_ignoreInvisibleFields = true;

    @NotNull
    public String getID() {
        return "InnerClassFieldHidesOuterClassField";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("inner.class.field.hides.outer.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("inner.class.field.hides.outer.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("inner.class.field.hides.outer.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreInvisibleFields");
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InnerClassVariableHidesOuterClassVariableVisitor();
    }

    private class InnerClassVariableHidesOuterClassVariableVisitor
    extends BaseInspectionVisitor {
        private InnerClassVariableHidesOuterClassVariableVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return;
            }
            String fieldName = field.getName();
            if ("serialVersionUID".equals(fieldName)) {
                return;
            }
            boolean reportStaticsOnly = aClass.hasModifierProperty("static");
            PsiClass ancestorClass = ClassUtils.getContainingClass((PsiElement)aClass);
            while (ancestorClass != null) {
                PsiField ancestorField = ancestorClass.findFieldByName(fieldName, false);
                if (!(ancestorField == null || InnerClassVariableHidesOuterClassVariableInspectionBase.this.m_ignoreInvisibleFields && reportStaticsOnly && !ancestorField.hasModifierProperty("static"))) {
                    this.registerFieldError(field, new Object[0]);
                }
                if (ancestorClass.hasModifierProperty("static")) {
                    reportStaticsOnly = true;
                }
                ancestorClass = ClassUtils.getContainingClass((PsiElement)ancestorClass);
            }
        }
    }
}

