/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JComponent;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class FieldHidesSuperclassFieldInspectionBase
extends BaseInspection {
    public boolean m_ignoreInvisibleFields = true;
    public boolean ignoreStaticFields = true;

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        super.writeSettings(node);
        for (Element child : new ArrayList(node.getChildren())) {
            String name = child.getAttributeValue("name");
            String value = child.getAttributeValue("value");
            if (!"ignoreStaticFields".equals(name) || !"true".equals(value)) continue;
            node.removeContent((Content)child);
        }
    }

    @NotNull
    public String getID() {
        return "FieldNameHidesFieldInSuperclass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("field.name.hides.in.superclass.display.name", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("field.name.hides.in.superclass.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("field.name.hides.in.superclass.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreInvisibleFields");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FieldHidesSuperclassFieldVisitor();
    }

    private class FieldHidesSuperclassFieldVisitor
    extends BaseInspectionVisitor {
        private FieldHidesSuperclassFieldVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            PsiClass aClass = field.getContainingClass();
            if (aClass == null) {
                return;
            }
            String fieldName = field.getName();
            if ("serialVersionUID".equals(fieldName)) {
                return;
            }
            HashSet<PsiClass> visitedClasses = new HashSet<PsiClass>();
            for (PsiClass ancestorClass = aClass.getSuperClass(); ancestorClass != null; ancestorClass = ancestorClass.getSuperClass()) {
                if (!visitedClasses.add(ancestorClass)) {
                    return;
                }
                PsiField ancestorField = ancestorClass.findFieldByName(fieldName, false);
                if (ancestorField == null || FieldHidesSuperclassFieldInspectionBase.this.m_ignoreInvisibleFields && !ClassUtils.isFieldVisible(ancestorField, aClass) || FieldHidesSuperclassFieldInspectionBase.this.ignoreStaticFields && field.hasModifierProperty("static") && ancestorField.hasModifierProperty("static")) continue;
                this.registerFieldError(field, new Object[0]);
                return;
            }
        }
    }
}

