/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class WaitOrAwaitWithoutTimeoutInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("wait.or.await.without.timeout.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("wait.or.await.without.timeout.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WaitWithoutTimeoutVisitor();
    }

    private static class WaitWithoutTimeoutVisitor
    extends BaseInspectionVisitor {
        private WaitWithoutTimeoutVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"wait".equals(methodName) && !"await".equals(methodName)) {
                return;
            }
            PsiExpressionList argList = expression.getArgumentList();
            PsiExpression[] args = argList.getExpressions();
            int numParams = args.length;
            if (numParams != 0) {
                return;
            }
            if ("await".equals(methodName)) {
                PsiMethod method = expression.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return;
                }
                String className = containingClass.getName();
                if (!"java.util.concurrent.locks.Condition".equals(className)) {
                    return;
                }
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }
}

