/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaitNotInSynchronizedContextInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "WaitWhileNotSynced";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("wait.not.in.synchronized.context.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String text;
        if (infos.length > 0) {
            PsiElement element = (PsiElement)infos[0];
            text = element.getText();
        } else {
            text = "this";
        }
        return InspectionGadgetsBundle.message("wait.not.in.synchronized.context.problem.descriptor", text);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WaitNotInSynchronizedContextVisitor();
    }

    private static class WaitNotInSynchronizedContextVisitor
    extends BaseInspectionVisitor {
        private WaitNotInSynchronizedContextVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"wait".equals(methodName)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            String qualifiedName = aClass.getQualifiedName();
            if (!"java.lang.Object".equals(qualifiedName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) {
                if (WaitNotInSynchronizedContextVisitor.isSynchronizedOnThis((PsiElement)expression)) {
                    return;
                }
                this.registerError((PsiElement)expression, new Object[0]);
            } else if (qualifier instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                PsiElement target = referenceExpression.resolve();
                if (WaitNotInSynchronizedContextVisitor.isSynchronizedOn((PsiElement)expression, target)) {
                    return;
                }
                this.registerError((PsiElement)expression, qualifier);
            }
        }

        private static boolean isSynchronizedOn(@NotNull PsiElement element, @Nullable PsiElement target) {
            if (target == null) {
                return false;
            }
            PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)element, PsiSynchronizedStatement.class);
            if (context == null) {
                return false;
            }
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)context;
            PsiExpression lockExpression = synchronizedStatement.getLockExpression();
            if (!(lockExpression instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lockExpression;
            PsiElement lockTarget = referenceExpression.resolve();
            return target.equals(lockTarget) || WaitNotInSynchronizedContextVisitor.isSynchronizedOn((PsiElement)synchronizedStatement, target);
        }

        private static boolean isSynchronizedOnThis(@NotNull PsiElement element) {
            PsiMethod method;
            PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiSynchronizedStatement.class});
            if (context instanceof PsiSynchronizedStatement) {
                PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)context;
                PsiExpression lockExpression = synchronizedStatement.getLockExpression();
                return lockExpression instanceof PsiThisExpression || WaitNotInSynchronizedContextVisitor.isSynchronizedOnThis((PsiElement)synchronizedStatement);
            }
            return context instanceof PsiMethod && (method = (PsiMethod)context).hasModifierProperty("synchronized");
        }
    }
}

