/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class VolatileArrayFieldInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("volatile.array.field.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[0];
        String typeString = type.getPresentableText();
        return InspectionGadgetsBundle.message("volatile.field.problem.descriptor", typeString);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new VolatileArrayFieldVisitor();
    }

    private static class VolatileArrayFieldVisitor
    extends BaseInspectionVisitor {
        private VolatileArrayFieldVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            super.visitField(field);
            if (!field.hasModifierProperty("volatile")) {
                return;
            }
            PsiType type = field.getType();
            if (type.getArrayDimensions() == 0) {
                return;
            }
            this.registerFieldError(field, type);
        }
    }
}

