/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

public class ThreadRunInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("thread.run.display.name", new Object[0]);
    }

    @NotNull
    public String getID() {
        return "CallToThreadRun";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("thread.run.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ThreadRunFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThreadRunVisitor();
    }

    private static class ThreadRunVisitor
    extends BaseInspectionVisitor {
        private ThreadRunVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"run".equals(methodName)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 0) {
                return;
            }
            PsiClass methodClass = method.getContainingClass();
            if (methodClass == null) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)methodClass, (String)"java.lang.Thread")) {
                return;
            }
            if (ThreadRunVisitor.isInsideThreadRun((PsiElement)expression)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private static boolean isInsideThreadRun(PsiElement element) {
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
            if (method == null) {
                return false;
            }
            String methodName = method.getName();
            if (!"run".equals(methodName)) {
                return false;
            }
            PsiClass methodClass = method.getContainingClass();
            if (methodClass == null) {
                return false;
            }
            return InheritanceUtil.isInheritor((PsiClass)methodClass, (String)"java.lang.Thread");
        }
    }

    private static class ThreadRunFix
    extends InspectionGadgetsFix {
        private ThreadRunFix() {
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("thread.run.replace.quickfix", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @Override
        public void doFix(@NotNull Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodNameIdentifier = descriptor.getPsiElement();
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)methodNameIdentifier.getParent();
            assert (methodExpression != null);
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                PsiReplacementUtil.replaceExpression((PsiExpression)methodExpression, "start");
            } else {
                String qualifierText = qualifier.getText();
                PsiReplacementUtil.replaceExpression((PsiExpression)methodExpression, qualifierText + ".start");
            }
        }
    }
}

