/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeFieldStaticFinalFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ThreadLocalNotStaticFinalInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("thread.local.not.static.final.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("thread.local.not.static.final.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return MakeFieldStaticFinalFix.buildFix((PsiField)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThreadLocalNotStaticFinalVisitor();
    }

    private static class ThreadLocalNotStaticFinalVisitor
    extends BaseInspectionVisitor {
        private ThreadLocalNotStaticFinalVisitor() {
        }

        public void visitField(PsiField field) {
            super.visitField(field);
            PsiType type = field.getType();
            if (!InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.ThreadLocal")) {
                return;
            }
            PsiModifierList modifierList = field.getModifierList();
            if (modifierList == null) {
                return;
            }
            if (modifierList.hasModifierProperty("static") && modifierList.hasModifierProperty("final")) {
                return;
            }
            this.registerFieldError(field, field);
        }
    }
}

