/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SynchronizedOnLiteralObjectInspection
extends BaseInspection {
    public boolean warnOnAllPossiblyLiterals = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("synchronized.on.literal.object.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String typeText = ((PsiType)infos[0]).getPresentableText();
        int message = (Integer)infos[1];
        switch (message) {
            case 1: {
                return InspectionGadgetsBundle.message("synchronized.on.literal.object.problem.descriptor", typeText);
            }
            case 2: {
                return InspectionGadgetsBundle.message("synchronized.on.direct.literal.object.problem.descriptor", typeText);
            }
            case 3: {
                return InspectionGadgetsBundle.message("synchronized.on.possibly.literal.object.problem.descriptor", typeText);
            }
        }
        throw new AssertionError();
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("synchronized.on.literal.object.warn.on.all.option", new Object[0]), (InspectionProfileEntry)this, "warnOnAllPossiblyLiterals");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizeOnLiteralVisitor();
    }

    private class SynchronizeOnLiteralVisitor
    extends BaseInspectionVisitor {
        private SynchronizeOnLiteralVisitor() {
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement2) {
            PsiClassType javaLangNumberType;
            super.visitSynchronizedStatement(statement2);
            PsiExpression lockExpression = statement2.getLockExpression();
            if (lockExpression == null) {
                return;
            }
            PsiType type = lockExpression.getType();
            if (type == null) {
                return;
            }
            if (!(type.equalsToText("java.lang.String") || type.equalsToText("java.lang.Boolean") || type.equalsToText("java.lang.Character") || (javaLangNumberType = TypeUtils.getType("java.lang.Number", (PsiElement)statement2)).isAssignableFrom(type))) {
                return;
            }
            if (!(lockExpression instanceof PsiReferenceExpression)) {
                if (ExpressionUtils.isLiteral(lockExpression)) {
                    this.registerError((PsiElement)lockExpression, type, 2);
                } else if (SynchronizedOnLiteralObjectInspection.this.warnOnAllPossiblyLiterals) {
                    this.registerError((PsiElement)lockExpression, type, 3);
                }
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lockExpression;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                if (SynchronizedOnLiteralObjectInspection.this.warnOnAllPossiblyLiterals) {
                    this.registerError((PsiElement)lockExpression, type, 3);
                }
                return;
            }
            PsiVariable variable = (PsiVariable)target;
            PsiExpression initializer = variable.getInitializer();
            if (!ExpressionUtils.isLiteral(initializer)) {
                if (SynchronizedOnLiteralObjectInspection.this.warnOnAllPossiblyLiterals) {
                    this.registerError((PsiElement)lockExpression, type, 3);
                }
                return;
            }
            this.registerError((PsiElement)lockExpression, type, 1);
        }
    }
}

