/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.threading.ThreadingUtils;
import org.jetbrains.annotations.NotNull;

public class SynchronizeOnThisInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("synchronize.on.this.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("synchronize.on.this.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizeOnThisVisitor();
    }

    private static class SynchronizeOnThisVisitor
    extends BaseInspectionVisitor {
        private SynchronizeOnThisVisitor() {
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement2) {
            super.visitSynchronizedStatement(statement2);
            PsiExpression lockExpression = statement2.getLockExpression();
            if (!(lockExpression instanceof PsiThisExpression)) {
                return;
            }
            this.registerError((PsiElement)lockExpression, new Object[0]);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier != null && !(qualifier instanceof PsiThisExpression)) {
                return;
            }
            if (!ThreadingUtils.isNotifyOrNotifyAllCall(expression) && !ThreadingUtils.isWaitCall(expression)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }
}

