/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class SynchronizeOnLockInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "SynchroniziationOnLockObject";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("synchronize.on.lock.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String type = (String)infos[0];
        return InspectionGadgetsBundle.message("synchronize.on.lock.problem.descriptor", type);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SynchronizeOnLockVisitor();
    }

    private static class SynchronizeOnLockVisitor
    extends BaseInspectionVisitor {
        private SynchronizeOnLockVisitor() {
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement2) {
            super.visitSynchronizedStatement(statement2);
            PsiExpression lockExpression = statement2.getLockExpression();
            if (lockExpression == null) {
                return;
            }
            String type = TypeUtils.expressionHasTypeOrSubtype(lockExpression, "java.util.concurrent.locks.Lock", "java.util.concurrent.locks.ReadWriteLock");
            if (type == null) {
                return;
            }
            this.registerError((PsiElement)lockExpression, type);
        }
    }
}

