/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

public class ObjectNotifyInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "CallToNotifyInsteadOfNotifyAll";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("object.notify.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("object.notify.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObjectNotifyVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ObjectNotifyFix();
    }

    private static class ObjectNotifyVisitor
    extends BaseInspectionVisitor {
        private ObjectNotifyVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"notify".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList.getExpressions().length != 0) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }

    private static class ObjectNotifyFix
    extends InspectionGadgetsFix {
        private ObjectNotifyFix() {
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("object.notify.replace.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement methodNameElement = descriptor.getPsiElement();
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)methodNameElement.getParent();
            assert (methodExpression != null);
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                PsiReplacementUtil.replaceExpression((PsiExpression)methodExpression, "notifyAll");
            } else {
                String qualifierText = qualifier.getText();
                PsiReplacementUtil.replaceExpression((PsiExpression)methodExpression, qualifierText + '.' + "notifyAll");
            }
        }
    }
}

