/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class NestedSynchronizedStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("nested.synchronized.statement.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("nested.synchronized.statement.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NestedSynchronizedStatementVisitor();
    }

    public static <T extends PsiStatement> boolean isNestedStatement(@NotNull T statement2, @NotNull Class<T> aClass) {
        return PsiTreeUtil.getParentOfType(statement2, aClass, (boolean)true, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class}) != null;
    }

    private static class NestedSynchronizedStatementVisitor
    extends BaseInspectionVisitor {
        private NestedSynchronizedStatementVisitor() {
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement2) {
            super.visitSynchronizedStatement(statement2);
            if (NestedSynchronizedStatementInspection.isNestedStatement(statement2, PsiSynchronizedStatement.class)) {
                this.registerStatementError((PsiStatement)statement2, new Object[0]);
            }
        }
    }
}

