/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class NakedNotifyInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("naked.notify.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("naked.notify.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NakedNotifyVisitor();
    }

    private static class NakedNotifyVisitor
    extends BaseInspectionVisitor {
        private NakedNotifyVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            super.visitMethod(method);
            if (!method.hasModifierProperty("synchronized")) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body != null) {
                this.checkBody(body);
            }
        }

        public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement2) {
            super.visitSynchronizedStatement(statement2);
            this.checkBody(statement2.getBody());
        }

        private void checkBody(PsiCodeBlock body) {
            PsiStatement firstStatement = ControlFlowUtils.getFirstStatementInBlock(body);
            if (!(firstStatement instanceof PsiExpressionStatement)) {
                return;
            }
            PsiExpression firstExpression = ((PsiExpressionStatement)firstStatement).getExpression();
            if (!(firstExpression instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)firstExpression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"notify".equals(methodName) && !"notifyAll".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            if (argumentList.getExpressions().length != 0) {
                return;
            }
            this.registerMethodCallError(methodCallExpression, new Object[0]);
        }
    }
}

