/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SynchronizationUtil;
import org.jetbrains.annotations.NotNull;

public class CallToNativeMethodWhileLockedInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("call.to.native.method.while.locked.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("call.to.native.method.while.locked.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CallToNativeMethodWhileLockedVisitor();
    }

    private static class CallToNativeMethodWhileLockedVisitor
    extends BaseInspectionVisitor {
        private CallToNativeMethodWhileLockedVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            if (!method.hasModifierProperty("native")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String className = containingClass.getQualifiedName();
            if ("java.lang.Object".equals(className)) {
                return;
            }
            if (!SynchronizationUtil.isInSynchronizedContext((PsiElement)expression)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }
}

