/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class NestedMethodCallInspectionBase
extends BaseInspection {
    public boolean m_ignoreFieldInitializations = true;
    protected boolean ignoreStaticMethods = false;
    protected boolean ignoreGetterCalls = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("nested.method.call.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("nested.method.call.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NestedMethodCallVisitor();
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        super.writeSettings(node);
        if (this.ignoreStaticMethods) {
            node.addContent(new Element("option").setAttribute("name", "ignoreStaticMethods").setAttribute("value", String.valueOf(this.ignoreStaticMethods)));
        }
        if (this.ignoreGetterCalls) {
            node.addContent(new Element("option").setAttribute("name", "ignoreGetterCalls").setAttribute("value", String.valueOf(this.ignoreGetterCalls)));
        }
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        super.readSettings(node);
        for (Element option : node.getChildren("option")) {
            if ("ignoreGetterCalls".equals(option.getAttributeValue("name"))) {
                this.ignoreGetterCalls = Boolean.parseBoolean(option.getAttributeValue("value"));
                continue;
            }
            if (!"ignoreStaticMethods".equals(option.getAttributeValue("name"))) continue;
            this.ignoreStaticMethods = Boolean.parseBoolean(option.getAttributeValue("value"));
        }
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    private class NestedMethodCallVisitor
    extends BaseInspectionVisitor {
        private NestedMethodCallVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiElement field;
            PsiMethodCallExpression outerExpression;
            super.visitMethodCallExpression(expression);
            for (outerExpression = expression; outerExpression != null && outerExpression.getParent() instanceof PsiExpression; outerExpression = (PsiExpression)outerExpression.getParent()) {
            }
            if (outerExpression == null) {
                return;
            }
            PsiElement parent = outerExpression.getParent();
            if (!(parent instanceof PsiExpressionList)) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiCallExpression)) {
                return;
            }
            if (ExpressionUtils.isConstructorInvocation(grandParent)) {
                return;
            }
            if (NestedMethodCallInspectionBase.this.m_ignoreFieldInitializations && (field = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiField.class)) != null) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            if (NestedMethodCallInspectionBase.this.ignoreStaticMethods || NestedMethodCallInspectionBase.this.ignoreGetterCalls) {
                if (NestedMethodCallInspectionBase.this.ignoreStaticMethods && method.hasModifierProperty("static")) {
                    return;
                }
                if (NestedMethodCallInspectionBase.this.ignoreGetterCalls && PropertyUtil.isSimpleGetter((PsiMethod)method)) {
                    return;
                }
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }
}

