/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class ExtendsObjectInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("extends.object.display.name", new Object[0]);
    }

    @NotNull
    public String getID() {
        return "ClassExplicitlyExtendsObject";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("extends.object.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ExtendsObjectFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExtendsObjectVisitor();
    }

    private static class ExtendsObjectVisitor
    extends BaseInspectionVisitor {
        private ExtendsObjectVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiClassType[] types;
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            for (PsiClassType type : types = aClass.getExtendsListTypes()) {
                if (!type.equalsToText("java.lang.Object")) continue;
                this.registerClassError(aClass, new Object[0]);
            }
        }
    }

    private static class ExtendsObjectFix
    extends InspectionGadgetsFix {
        private ExtendsObjectFix() {
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("extends.object.remove.quickfix", new Object[0]);
        }

        @Override
        public void doFix(@NotNull Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiJavaCodeReferenceElement[] referenceElements;
            PsiElement extendClassIdentifier = descriptor.getPsiElement();
            PsiClass element = (PsiClass)extendClassIdentifier.getParent();
            if (element == null) {
                return;
            }
            PsiReferenceList extendsList = element.getExtendsList();
            if (extendsList == null) {
                return;
            }
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = extendsList.getReferenceElements()) {
                ExtendsObjectFix.deleteElement((PsiElement)referenceElement);
            }
        }
    }
}

