/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class ChainedMethodCallInspectionBase
extends BaseInspection {
    public boolean m_ignoreFieldInitializations = true;
    public boolean m_ignoreThisSuperCalls = true;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("chained.method.call.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("chained.method.call.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ChainedMethodCallVisitor();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    private class ChainedMethodCallVisitor
    extends BaseInspectionVisitor {
        private ChainedMethodCallVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiElement parent;
            PsiExpressionList expressionList;
            PsiElement field;
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression reference = expression.getMethodExpression();
            PsiExpression qualifier = reference.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            if (!this.isCallExpression(qualifier)) {
                return;
            }
            if (ChainedMethodCallInspectionBase.this.m_ignoreFieldInitializations && (field = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiField.class)) != null) {
                return;
            }
            if (ChainedMethodCallInspectionBase.this.m_ignoreThisSuperCalls && (expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiExpressionList.class)) != null && ExpressionUtils.isConstructorInvocation(parent = expressionList.getParent())) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        private boolean isCallExpression(PsiExpression expression) {
            return (expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiMethodCallExpression || expression instanceof PsiNewExpression;
        }
    }
}

